#include <i2c.h>
#include <p30fxxxx.h>

/*********************************************************************
*    Function Name:  ConfigIntI2C										
*    Description:    This routine enables/disables the SI2C & MI2C  
*                    interrupts and sets their priorities
*    Parameters:     unsigned int : config	
*    Return Value:   void
*********************************************************************/

void ConfigIntI2C(unsigned int config)
{
     IFS0bits.SI2CIF = 0;		                 /* clear the MI2C & SI2C Interrupts */
     IFS0bits.MI2CIF = 0;

     IPC3bits.SI2CIP = (config & 0x0007);	     /* set the SI2C priority */
     IPC3bits.MI2CIP = (config & 0x0070) >> 4;    /* set the MI2C priority */

     IEC0bits.SI2CIE = (config & 0x0008)>> 3;	 /* enable/disable the SI2C Interrupt */
     IEC0bits.MI2CIE = (config & 0x0080) >> 7;    /* enable/disable the MI2C Interrupt */
}
